import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

/**
 *
 *@author liporron
 *@modified jsgarcia
 *      Send comments to regulondb@ccg.unam.mx
 *@name ClientNetWorkgetSigmaTU
 *@version 2.0
 *@time
 *<18/10/2010 -11:00pm  liporron>
 *@description This is a client that call the Web service NetWork and its method getSigmaTU
 *@output String
 * SigmaFactorName(regulator)
 * TUName(regulated)[TU genes]
 * Sign(effect)
 * Evidence Code of the interaction
 * separated by tab
 *@category Client web Service
 *@usage java ClientNetWorkgetSigmaTU
 *@environment PATH variable with Axis libraries
 *@param none
 *@requirements Axis library
*/

public class ClientNetWorkgetSigmaTU  {
    public static void main (String args[])throws Exception{
        try{
            //calling the Web services
            //getting the column names
            String endPoint = "http://regulondb.ccg.unam.mx/webservices/NetWork.jws";
            String method="getColumnNames";
            String nameWSMethod="getSigmaTU";
            Service service=new Service();
            Call callgetColumnNames=(Call) service.createCall();
            callgetColumnNames.setTargetEndpointAddress (new java.net.URL(endPoint));
            callgetColumnNames.setOperationName (method);
            callgetColumnNames.addParameter ("methodName", XMLType.XSD_STRING, ParameterMode.IN);
            callgetColumnNames.setReturnType (XMLType.XSD_STRING);
            String columnNames = (String) callgetColumnNames.invoke (new Object [] {nameWSMethod});
            System.out.print(columnNames);
            System.out.print("\n");
            //getting the data
            method=nameWSMethod;
            Call callWS=(Call) service.createCall();
            callWS.setTargetEndpointAddress (new java.net.URL(endPoint));
            callWS.setOperationName (method);
            callWS.setReturnType (XMLType.XSD_STRING);
            String result = (String) callWS.invoke (new Object [] {});
            System.out.print(result);
        }catch (Exception e){
            System.out.println("\t Exception: The server is not responding \n "+e);
        }
    }
}